<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Consignment;

final class SDSOptions implements \JsonSerializable
{
    /**
     * @var string
     */
    private $id;

    /**
     * @var string
     */
    private $name1;

    /**
     * @var string
     */
    private $name2;

    /**
     * @var string
     */
    private $name3;

    /**
     * @var string
     */
    private $country;

    /**
     * @var string
     */
    private $zipcode;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string
     */
    private $street;

    /**
     * @var string
     */
    private $phone;

    /**
     * @var string
     */
    private $email;

    /**
     * @var float
     */
    private $gps_lati;

    /**
     * @var float
     */
    private $gps_long;

    /**
     * @var string
     */
    private $mon_open;

    /**
     * @var string
     */
    private $mon_close;

    /**
     * @var string
     */
    private $tue_open;

    /**
     * @var string
     */
    private $tue_close;

    /**
     * @var string
     */
    private $wed_open;

    /**
     * @var string
     */
    private $wed_close;

    /**
     * @var string
     */
    private $thu_open;

    /**
     * @var string
     */
    private $thu_close;

    /**
     * @var string
     */
    private $fri_open;

    /**
     * @var string
     */
    private $fri_close;

    /**
     * @var string
     */
    private $sat_open;

    /**
     * @var string
     */
    private $sat_close;

    /**
     * @var string
     */
    private $sun_open;

    /**
     * @var string
     */
    private $sun_close;

    public function __construct(string $parcelShopId)
    {
        $this->id = $parcelShopId;
    }

    public function getParcelShopId(): string
    {
        return $this->id;
    }

    public function getName1(): string
    {
        return $this->name1;
    }

    public function getName2(): string
    {
        return $this->name2;
    }

    public function getName3(): string
    {
        return $this->name3;
    }

    public function getCountry(): string
    {
        return $this->country;
    }

    public function getZipcode(): string
    {
        return $this->zipcode;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function getStreet(): string
    {
        return $this->street;
    }

    public function getPhone(): string
    {
        return $this->phone;
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    public function getGps_lati(): float
    {
        return $this->gps_lati;
    }

    public function getGps_long(): float
    {
        return $this->gps_long;
    }

    public function getMon_open(): string
    {
        return $this->mon_open;
    }

    public function getMon_close(): string
    {
        return $this->mon_close;
    }

    public function getTue_open(): string
    {
        return $this->tue_open;
    }

    public function getTue_close(): string
    {
        return $this->tue_close;
    }

    public function getWed_open(): string
    {
        return $this->wed_open;
    }

    public function getWed_close(): string
    {
        return $this->wed_close;
    }

    public function getThu_open(): string
    {
        return $this->thu_open;
    }

    public function getThu_close(): string
    {
        return $this->thu_close;
    }

    public function getFri_open(): string
    {
        return $this->fri_open;
    }

    public function getFri_close(): string
    {
        return $this->fri_close;
    }

    public function getSat_open(): string
    {
        return $this->sat_open;
    }

    public function getSat_close(): string
    {
        return $this->sat_close;
    }

    public function getSun_open(): string
    {
        return $this->sun_open;
    }

    public function getSun_close(): string
    {
        return $this->sun_close;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
