<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Pickup;

use Gls\GlsPoland\AdePlus\Authorization\AuthorizedRequest;
use Gls\GlsPoland\AdePlus\Consignment\ConsignmentIdsCollection;

final class Create extends AuthorizedRequest
{
    /**
     * @var ConsignmentIdsCollection
     */
    private $consigns_ids;

    /**
     * @var string
     */
    private $desc;

    public function __construct(ConsignmentIdsCollection $consignmentIds, string $description)
    {
        $this->consigns_ids = $consignmentIds;
        $this->desc = $description;
    }

    public function jsonSerialize(): array
    {
        return [
            'consigns_ids' => $this->consigns_ids,
            'desc' => $this->desc,
        ];
    }

    public function getConsignmentIds(): ConsignmentIdsCollection
    {
        return $this->consigns_ids;
    }

    public function withConsignmentIds(ConsignmentIdsCollection $consignmentIds): Create
    {
        $new = clone $this;
        $new->consigns_ids = $consignmentIds;

        return $new;
    }

    public function getDescription(): string
    {
        return $this->desc;
    }

    public function withDescription(string $description): Create
    {
        $new = clone $this;
        $new->desc = $description;

        return $new;
    }
}
