<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus;

use Symfony\Component\Validator\Constraints as Assert;

class UserCredentials implements UserCredentialsInterface
{
    /**
     * @Assert\NotBlank
     * @Assert\Length(max="40")
     */
    private $username;

    /**
     * @Assert\NotBlank
     * @Assert\Length(max="40")
     */
    private $password;

    public function __construct(string $username, string $password)
    {
        $this->username = $username;
        $this->password = $password;
    }

    public function getUsername(): string
    {
        return $this->username;
    }

    public function getPassword(): string
    {
        return $this->password;
    }

    public function __debugInfo(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        return [
            'username' => $this->username,
        ];
    }
}
