<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\Consignment\DTO\ServiceDetails;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class CourierServiceDetailsType extends AbstractType
{
    use TranslatorAwareTrait;

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('parcelShopId', HiddenType::class, [
                'data' => null,
            ])
            ->add('documentReturn', SwitchType::class, [
                'required' => false,
                'label' => $this->getTranslator()->trans('Document return', [], 'Modules.Glspoland.Consignment'),
            ])
            ->add('saturdayDelivery', SwitchType::class, [
                'required' => false,
                'label' => $this->getTranslator()->trans('Saturday delivery', [], 'Modules.Glspoland.Consignment'),
            ])
            ->add('timeDefiniteService', TimeDefiniteServiceChoiceType::class, [
                'required' => false,
                'label' => $this->getTranslator()->trans('Next day delivery', [], 'Modules.Glspoland.Consignment'),
                'placeholder' => $this->getTranslator()->trans('No', [], 'Admin.Global'),
            ])
            ->add('cashOnDeliveryAmount', MoneyType::class, [
                'required' => false,
                'label' => $this->getTranslator()->trans('Cash on delivery amount', [], 'Modules.Glspoland.Consignment'),
                'currency' => 'PLN',
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefault('data_class', ServiceDetails::class);
    }
}
