<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\AdePlus\Printout\LabelsPrintMode;
use Gls\GlsPoland\Form\DataTransformer\LabelsPrintModeDataTransformer;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class LabelsPrintModeChoiceType extends AbstractType
{
    use TranslatorAwareTrait;

    public function getParent(): string
    {
        return ChoiceType::class;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->addModelTransformer(new LabelsPrintModeDataTransformer());
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $translator = $this->getTranslator();

        $resolver
            ->setDefaults([
                'data_class' => null,
                'choices' => [
                    $translator->trans('PDF, single label per A4 page, top left corner', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::PDF_A4_TOP_LEFT,
                    $translator->trans('PDF, single label per A4 page, top right corner', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::PDF_A4_TOP_RIGHT,
                    $translator->trans('PDF, single label per A4 page, bottom left corner', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::PDF_A4_BOTTOM_LEFT,
                    $translator->trans('PDF, single label per A4 page, bottom right corner', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::PDF_A4_BOTTOM_RIGHT,
                    $translator->trans('PDF, single label per A4 page, center', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::PDF_A4_CENTER,
                    $translator->trans('PDF, 4 labels per A4 page, from top left corner', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::PDF_A4_FOUR_FROM_LEFT,
                    $translator->trans('PDF, 4 labels per A4 page, from top right corner', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::PDF_A4_FOUR_FROM_RIGHT,
                    $translator->trans('PDF, 160x100mm thermal paper, horizontally', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::PDF_ROLL_HORIZONTAL,
                    $translator->trans('PDF, 160x100mm thermal paper, vertically', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::PDF_ROLL_VERTICAL,
                    $translator->trans('DPL, 160x100mm thermal paper', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::DPL_ROLL,
                    $translator->trans('ZPL, 160x100mm thermal paper', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::ZPL_ROLL,
                    $translator->trans('ZPL, 160x100mm thermal paper, 300dpi', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::ZPL_ROLL_300_DPI,
                    $translator->trans('EPL, 160x100mm thermal paper', [], 'Modules.Glspoland.Printout') => LabelsPrintMode::EPL_ROLL,
                ],
            ]);
    }
}
