<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\TypeExtension;

use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Defines options not present before Sf 4 and PS 8.
 *
 * @internal
 */
final class NumberCompatibilityTypeExtension extends AbstractTypeExtension
{
    public static function getExtendedTypes(): iterable
    {
        return [NumberType::class];
    }

    public function getExtendedType(): string
    {
        return NumberType::class;
    }

    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        if (isset($options['unit'])) {
            $view->vars['unit'] = $options['unit'];
        }

        if ($options['html5']) {
            $view->vars['type'] = 'number';
        }
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        if (!$resolver->isDefined('unit')) {
            $resolver
                ->setDefined('unit')
                ->setAllowedTypes('unit', 'string');
        }

        if (!$resolver->isDefined('html5')) {
            $resolver
                ->setDefault('html5', false)
                ->setAllowedTypes('html5', 'bool');
        }
    }
}
