<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Checkout\Event;

use Gls\GlsPoland\EventDispatcher\Event;
use Symfony\Component\HttpFoundation\Request;

abstract class AbstractCheckoutEvent extends Event
{
    private $cart;
    private $request;

    public function __construct(\Cart $cart, Request $request)
    {
        $this->cart = $cart;
        $this->request = $request;
    }

    public function getRequest(): Request
    {
        return $this->request;
    }

    public function getCart(): \Cart
    {
        return $this->cart;
    }
}
