<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Checkout\Exception;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

class AbortCheckoutException extends \RuntimeException
{
    /**
     * @var Response
     */
    private $response;

    public function __construct(Response $response, string $message = '', int $code = 0, ?\Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);

        $this->response = $response;
    }

    /**
     * @param mixed $data
     */
    public static function json($data, int $statusCode = Response::HTTP_UNPROCESSABLE_ENTITY): self
    {
        return new self(JsonResponse::create($data, $statusCode));
    }

    public function getResponse(): Response
    {
        return $this->response;
    }
}
