<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\Engine\Metadata\Model;

use Gls\GlsPoland\Soap\Engine\Metadata\Collection\ParameterCollection;

final class Method
{
    /**
     * @var string
     */
    private $name;
    /**
     * @var ParameterCollection
     */
    private $parameters;
    /**
     * @var XsdType
     */
    private $returnType;

    public function __construct(string $name, ParameterCollection $parameters, XsdType $returnType)
    {
        $this->name = $name;
        $this->returnType = $returnType;
        $this->parameters = $parameters;
    }

    public function getParameters(): ParameterCollection
    {
        return $this->parameters;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getReturnType(): XsdType
    {
        return $this->returnType;
    }
}
