<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\ExtSoapEngine;

use Gls\GlsPoland\Soap\Engine\DecoderInterface;
use Gls\GlsPoland\Soap\Engine\HttpBinding\SoapResponse;
use Gls\GlsPoland\Soap\ExtSoapEngine\Generator\DummyMethodArgumentsGenerator;

final class ExtSoapDecoder implements DecoderInterface
{
    /**
     * @var AbusedClient
     */
    private $client;
    /**
     * @var DummyMethodArgumentsGenerator
     */
    private $argumentsGenerator;

    public function __construct(AbusedClient $client, DummyMethodArgumentsGenerator $argumentsGenerator)
    {
        $this->client = $client;
        $this->argumentsGenerator = $argumentsGenerator;
    }

    public function decode(string $method, SoapResponse $response)
    {
        $this->client->registerResponse($response);
        try {
            $decoded = $this->client->__soapCall($method, $this->argumentsGenerator->generateForSoapCall($method));
        } finally {
            $this->client->cleanUpTemporaryState();
        }

        return $decoded;
    }
}
